<?php

namespace App\Models;

use App\Models\Applicant;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Job extends Model
{
    use HasFactory;
    protected $guarded = [];
   

    /**
     * The applicants that belong to the Job
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function applicants()
    {
        return $this->belongsToMany(Applicant::class, 'applicants_jobs', 'jobs_id', 'applicants_id');
    }


    public function createdAt():Attribute
    {
        return new Attribute(

    get: fn($value)=> Carbon::parse($this->value)->format('F, d, Y')
        );

    }

   public function closingDate1(){
    return Carbon::parse($this->closing_date)->format('F, d, Y');
   }
}