<?php

use App\Models\Banner;
use App\Models\Menu;
use App\Models\Social;
use App\Models\Product;
use App\Models\SubMenu;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\App;


if(!function_exists('get_available_langs')){
    function get_available_langs(){
        return [
            'en'=>'English',
            'da'=>'دری',
            'pa'=>'پشتو'
        ];
    }
}

if(!function_exists('appLocal')){
    function appLocal(){
        return App::getLocale();
    }
}

if(!function_exists('render_route')){
    function render_route($path='/',$param=null){
         if($param){
             return route($path,[appLocal(),$param]);
         }else{
             return route($path,[appLocal()]);
         }
    }

}



if(!function_exists('render_sub_menu_name')){
   function render_sub_menu_name($menu){
         if(appLocal(

         ) =='en'){
             $menuName = $menu["sub_menu_name"];
         }else{
             $menuName = $menu[appLocal()."_"."sub_menu_name"];
         }
         return $menuName;
   }
}




if(!function_exists('render_menu_name')){
   function render_menu_name($menu){
         if(appLocal() =='en'){
             $menuName = $menu["menu_name"];
         }else{
             $menuName = $menu[appLocal()."_"."menu_name"];
         }
         return $menuName;
   }
}

if(!function_exists('render_menu_url')){
   function render_menu_url($menu){
         if($menu->route_name=='#'){
            return '#';
         }
         if($menu->resource_id){
             $menu_url =   route('pages.show',[appLocal(),$$menu->resource_id]);
         }else{
             $menu_url =   route($menu->route_name,[appLocal()]);
         }
         return $menu_url;
   }
}






if(!function_exists('render_sub_menu_url')){
   function render_sub_menu_url($menu){
         if($menu->sub_resource_id){
             $menu_url =   route('pages.show',[appLocal(),$menu->sub_resource_id]);
         }else{
             $menu_url =   route($menu->sub_route_name,[appLocal()]);
         }
         return $menu_url;
   }
}



if(!function_exists('is_rtl')){
   function is_rtl(){
    if(appLocal()=='en'){
        return false;
    }
    return true;
   }
}

if(!function_exists('get_direction')){
   function get_direction(){
    if(appLocal()=='en'){
        return 'ltr';
    }
        return 'rtl';

   }
}

if(!function_exists('get_menus')){
   function get_menus(){
        return  Menu::with('sub_menus')->orderBy('menu_order')->get();
   }
}

if(!function_exists('get_menus_for_footer')){
    function get_menus_for_footer(){
     $menus = Menu::with('sub_menus')->orderBy('menu_order')->where('route_name','!=','#')->skip(1)->limit(4)->get();
     return $menus;
    }
 }


 if(!function_exists('get_sub_menus_for_navbar')){
    function get_sub_menus_for_navbar(){
        $menus = SubMenu::get();
        return $menus;
    }
 }




if(!function_exists('render_sub_menu_url')){
   function render_sub_menu_url($menu){
         if($menu->sub_resource_id){
             $menu_url =   route('pages.show',[appLocal(),$menu->sub_resource_id]);
         }else{
             $menu_url =   route($menu->sub_route_name,[appLocal()]);
         }
         return $menu_url;
   }
}


if(!function_exists('render_logo_path')){
   function render_logo_path($item){
                if(appLocal() =='en'){
             $image = render_image_path($item["logo"]);
         }else{
             $image = render_image_path($item["da_logo"]);
         }
         return $image;
   }
}

if(!function_exists('render_logo_path_footer')){
   function render_logo_path_footer($item){
                if(appLocal() =='en'){
             $image = render_image_path($item["footer_logo"]);
         }else{
             $image = render_image_path($item["da_footer_logo"]);
         }
         return $image;
   }
}




if(!function_exists('render_multiple_image_path')){
   function render_multiple_image_path($item){
            if(appLocal() =='en'){
             $image = render_image_path($item["image"]);
         }else{
             $image = render_image_path($item[appLocal()."_"."image"]);
         }
         return $image;
   }
}

if(!function_exists('render_multiple_image_path_product')){
   function render_multiple_image_path_product($item){
             $image = render_image_path($item["caption_image"]);
         return $image;
   }
}


if(!function_exists('render_post_title')){
   function render_post_title($item){
                if(appLocal() =='en'){
             $title = $item["title"];
         }else{
             $title = $item[appLocal()."_"."title"];
         }
         return $title;
   }
}

if(!function_exists('render_post_description')){
   function render_post_description($item){
             if(appLocal() =='en'){
             $description = $item["description"];
         }else{
             $description = $item[appLocal()."_"."description"];
         }
         return $description;
   }
}




if(!function_exists('render_date')){
   function render_date($item){

    $date = Carbon::parse($item);
    $formattedDate = $date->format('d F Y');
         return $formattedDate;
   }
}




if(!function_exists('provinces')){
   function provinces(){

     return ["Kabul", "Badghis", "Herat","Bamyan","Balkh","Faryab","Jawzjan","Ghor","Sar-e-Pul","Farah","Helmand","Nimroz","Urozgan","Dykundi","Kandahar","Zabul","Ghazni","Khost","Paktika","Badakhshan","Nooristan","Kunar","Kunduz","Nangarhar","Takhar","Baghlan","Kapisa","Panjsher","Laghman","Logar","Parwan","Samangan","Wardak","Paktya"];

   }
}




if(!function_exists('get_product_for_order')){
   function get_product_for_order(){
       $products = Product::latest()->get();
       return $products;
   }
}


if(!function_exists('clients')){
    function clients(){
        $clients  = Social::latest()->where('type','Client')->get();
        return $clients;
    }
}



if(!function_exists('get_banners')){
    function get_banners($section){
        $banners = Banner::where('section',$section)->first();
        return $banners;
    }
}