<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sub_menus', function (Blueprint $table) {
            $table->id();
            $table->string('sub_menu_name');
            $table->string('da_sub_menu_name');
            $table->string('pa_sub_menu_name');
            $table->integer('sub_resource_id')->nullable();
            $table->string('sub_resource_type')->nullable();
            $table->string('sub_route_name');
            $table->string('sub_menu_icon')->nullable();
            $table->integer('sub_menu_order');
            $table->unsignedBigInteger('menu_id');
            $table->foreign('menu_id')->references('id')->on('menus')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sub_menus');
    }
};