@extends('Admin.master_page')
@section('small_title')
{{__("lable.setting")}}
@endsection

@section('content')



                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Setting</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">Setting</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                            <div class="alert alert-info">{{ Session::get('message') }}</div>

                            @endif

                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        @if ($companies->isEmpty())
                                        <a type="button" href="{{route('companies.create')}}" class="btn btn-primary "> Add </a>
                                        @endif
                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">


                        <div class="table-responsive">

                            <table class="table table-striped">
                            <tr>
                                <th>  Name  </th>
                                <th>  Logo </th>

                                <th>  Phone 1 </th>
                                <th>  Phone 2 </th>
                                <th>  Email 1 </th>
                                <th>  Email 2 (Order) </th>
                                <th>  Location 1 </th>
                                <th>  Location 2 </th>
                                <th>  Facebook </th>
                                <th>  Twitter </th>
                                <th>  Youtube </th>
                                <th>  Instagram </th>
                                <th>  Linkedin </th>
                                <th>  Action </th>

                            </tr>

                            @foreach($companies as $company)

                            <tr>
                                <td>
                                    <p>{{ $company->name }}</p>


                                </td>
                                <td>
                                    <img src="{{render_image_path($company->logo)}}" width="150" height="100" title="{{ $company->name}} image">
                                   <hr/>
                                    <img src="{{render_image_path($company->da_logo)}}" width="150" height="100" title="{{ $company->name}} image">
                                   <hr>
                                      <img src="{{render_image_path($company->footer_logo)}}" width="150" height="100" title="{{ $company->name}} image">
                                      <hr>
                                      <img src="{{render_image_path($company->da_footer_logo)}}" width="150" height="100" title="{{ $company->name}} image">
                                </td>
                                <td>
                                    <p>{{ $company->phone1 }}</p>


                                </td>
                                <td>
                                    <p>{{ $company->phone2}}</p>


                                </td>
                                <td>
                                    <p>{{ $company->email1 }}</p>


                                </td>
                                <td>
                                    <p>{{ $company->email2 }}</p>


                                </td>
                                <td>
                                    <p>{{ $company->location1 }}</p>


                                </td>
                                <td>
                                    <p>{{ $company->location2 }}</p>


                                </td>
                                <td>
                                    <p>{{ $company->facebook }}</p>


                                </td>
                                <td>
                                    <p>{{ $company->twitter }}</p>


                                </td>
                                <td>
                                    <p>{{ $company->youtube }}</p>


                                </td>
                                  <td>
                                    <p>{{ $company->instagram }}</p>


                                </td>

                                   <td>
                                    <p>{{ $company->linkedin }}</p>


                                </td>
                                    <td>
                                            <form action="{{route('companies.destroy' , $company->id)}}" method="post" id="form-{{$company->id}}">
                                                {{csrf_field()}}
                                                {{method_field("DELETE")}}
                                            </form>

                                            <a href="{{ route('companies.edit' , $company->id) }}" ><i class="fas fa-edit"></i></a>

                                            &nbsp;
                                                           <a href=""
                                               onclick="if(confirm('Are you sure to delete?')) {
                                                       event.preventDefault();
                                                       document.getElementById('form-{{$company->id}}').submit();
                                                       }else{ event.preventDefault(); }"
                                               ><i class="fas fa-trash-alt"></i></a>
                                        </td>


                            </tr>

                            @endforeach

                        </table>

                        <br>


                        </div>

                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

