@extends('Admin.master_page')
@section('small_title')
{{__("dashboard.menu.project")}}
@endsection
@section('content')
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18"> Add </h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">  {{__("dashboard.menu.counter")}}  </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
<div class="alert alert-info">{{ Session::get('message') }}</div>

@endif
                        </div>
                        <!-- end page title -->

                        <div>
                            <form method="post" action="{{ route('counters.store') }}" enctype="multipart/form-data">
                                @csrf

                                <div class="col-lg-12">
                                      <h6 class="m-0 font-weight-bold text-primary pull-left" >Icon</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{old('icon')}}" name="icon" class="form-control" placeholder="">
                                    @error('icon')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>


                                    <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (English)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{old('title')}}" name="title" class="form-control" placeholder="">
                                    @error('title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                 <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Dari)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{old('da_title')}}" name="da_title" class="form-control" placeholder="">
                                    @error('da_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Pashto)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{old('pa_title')}}" name="pa_title" class="form-control" placeholder="">
                                    @error('pa_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>


                                <h6 class="m-0 font-weight-bold text-primary pull-left" >{{__("lable.value")}}</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" value="{{old('value')}}" required name="value" class="form-control" placeholder="">
                                    @error('value')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>



                            </div>
                            <br>

                                <input type="submit" value="Save" class="btn btn-secondary">


                            </form>
                        </div>




</div>
<!-- container-fluid -->
</div>
<!-- End Page-content -->



@endsection

@section('script')
<script>
    CKEDITOR.replace( 'summary-ckeditor1' );

</script>


@endsection


