@extends('Admin.master_page')
@section('small_title')
Gallery
@endsection
@section('content')
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">{{__("dashboard.menu.donar_logo")}}</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">{{__("dashboard.menu.donar_logo")}}</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                            @if(Session::has('message'))
                            <div class="alert alert-info">{{ Session::get('message') }}</div>

                            @endif

                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <a type="button" href="{{route('donars.create')}}" class="btn btn-primary "> Add </a>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">


                                              <div class="row">
                                                  @foreach($donars as $item)
                                                  <div class="col-xl-4 col-md-6">
                                                      <!-- card -->
                                                      <div class="card card-h-100">
                                                          <!-- card body -->
                                                          <div class="card-body">
                                                              <div class="row align-items-center">
                                                                  <div class="col-12">


                                                                      <img src="{{render_image_path($item->url)}}" alt="" width="100%">
                                                                      <br>


                                                                  </div>


                                                              </div>
                                                              <div class="col-md-4">
                                                                <form action="{{route('donars.destroy' , $item->id)}}" method="post" id="form-{{$item->id}}">
                                                                    {{csrf_field()}}
                                                                    {{method_field("DELETE")}}
                                                                </form>


                                                                &nbsp;
                                                                               <a href=""
                                                                   onclick="if(confirm('Are you sure to delete?')) {
                                                                           event.preventDefault();
                                                                           document.getElementById('form-{{$item->id}}').submit();
                                                                           }else{ event.preventDefault(); }"
                                                                   ><i class="fas fa-trash-alt"></i></a>
                                                            </div>

                                                          </div><!-- end card body -->
                                                      </div><!-- end card -->
                                                  </div><!-- end col-->
                                                  @endforeach
                                              </div><!-- end row-->

                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->
@endsection

