@extends('Admin.master_page')
@section('small_title')
Event

@endsection

@section('content')
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Add</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">Event</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
<div class="alert alert-info">{{ Session::get('message') }}</div>

@endif
                        </div>
                        <!-- end page title -->

                        <div>
                            <form method="post" action="{{ route('events.store') }}" enctype="multipart/form-data">
                                @csrf

                                <div class="col-lg-12">

                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Date</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="date" required value="{{old('start_date')}}" name="start_date" class="form-control" placeholder="">
                                    @error('start_date')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Location</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{old('location')}}" name="location" class="form-control" placeholder="">
                                    @error('location')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                    <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (English)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{old('title')}}" name="title" class="form-control" placeholder="">
                                    @error('title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                 <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Dari)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{old('da_title')}}" name="da_title" class="form-control" placeholder="">
                                    @error('da_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Pashto)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{old('pa_title')}}" name="pa_title" class="form-control" placeholder="">
                                    @error('pa_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>



                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (English)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="description" id="summary-ckeditor" cols="30" rows="8" class="form-control">
                                          {!!old('description')!!}
                                    </textarea>
                                    @error('description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (Dari)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="da_description" id="summary-ckeditor_da" cols="30" rows="8" class="form-control">
                                          {!!old('da_description')!!}
                                    </textarea>
                                    @error('da_description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (Pashto)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="pa_description" id="summary-ckeditor_pa" cols="30" rows="8" class="form-control">
                                          {!!old('pa_description')!!}
                                    </textarea>
                                    @error('pa_description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Image</h6>
                                <hr>
                                <div class="fileinput fileinput-new"data-provides="fileinput">
                                    <div class="fileinput-new img-thumbnail" style="width: 150px; height: 150px;">
                                        <img src="http://via.placeholder.com/"  alt="...">
                                    </div>
                                    <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                                    <div class="mt-2">
                                        <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new">Select Image </span><span class="fileinput-exists">Edit</span><input type="file" name="image"></span>
                                        <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                                    </div>
                                    @error('image')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                            </div>

                                <input type="submit" value="Save" class="btn btn-secondary">


                            </form>
                        </div>

</div>
<!-- container-fluid -->
</div>
<!-- End Page-content -->



@endsection



@section('script')
<script>
       CKEDITOR.replace( 'summary-ckeditor');
    CKEDITOR.replace( 'summary-ckeditor_da', {
    contentsLangDirection: 'rtl'
} );

   CKEDITOR.replace( 'summary-ckeditor_pa', {
    contentsLangDirection: 'rtl'
} );
</script>

@endsection



