@extends('Admin.master_page')
@section('small_title')
Gallery
@endsection
@section('content')
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Gallery</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">Gallery</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                            @if(Session::has('message'))
                            <div class="alert alert-info">{{ Session::get('message') }}</div>

                            @endif

                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <a type="button" href="{{route('imageGallaries.create')}}" class="btn btn-primary "> Add </a>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">


                                              <div class="row">
                                                  @foreach($imageGallaries as $imageGallary)
                                                  <div class="col-xl-4 col-md-6">
                                                      <!-- card -->
                                                      <div class="card card-h-100">
                                                          <!-- card body -->
                                                          <div class="card-body">
                                                              <div class="row align-items-center">
                                                                  <div class="col-12">
                                                                      <p>{{$imageGallary->title}}</p>

                                                                      @if ($imageGallary->type =='Image')

                                                                      <img src="{{render_image_path($imageGallary->url)}}" alt="" width="100%">
                                                                      @elseif($imageGallary->type =='File')
                                                                        <p>
                                                                            <a href="{{render_image_path($imageGallary->url)}}" download>
                                                                                Download
                                                                            </a>
                                                                        </p>
                                                                      @else

                                                                        <video  muted autoplay loop  src="{{render_image_path($imageGallary->url)}}" alt="" width="100%"></video>
                                                                      @endif
                                                                      <br>

                                                                  </div>

                                                                  <hr>
                                                                  <div class="col-md-4">
                                                                      <form action="{{route('imageGallaries.destroy' , $imageGallary->id)}}" method="post" id="form-{{$imageGallary->id}}">
                                                                          {{csrf_field()}}
                                                                          {{method_field("DELETE")}}
                                                                      </form>

                                                                      <a href="{{ route('imageGallaries.edit' , $imageGallary->id) }}" ><i class="fas fa-edit"></i></a>

                                                                      &nbsp;
                                                                                     <a href=""
                                                                         onclick="if(confirm('Are you sure to delete?')) {
                                                                                 event.preventDefault();
                                                                                 document.getElementById('form-{{$imageGallary->id}}').submit();
                                                                                 }else{ event.preventDefault(); }"
                                                                         ><i class="fas fa-trash-alt"></i></a>
                                                                  </div>

                                                              </div>

                                                          </div><!-- end card body -->
                                                      </div><!-- end card -->
                                                  </div><!-- end col-->
                                                  @endforeach
                                              </div><!-- end row-->

                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->
@endsection

