<!doctype html>
<html>

<head>

    <meta charset="utf-8" />
    <title>@yield('small_title') @if (company())
            - {{ company()->name }}
        @endif
    </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="{{company()?company()->name:''}} Admin Panel" name="description" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="@if (company()) {{ render_image_path(company()->logo) }} @endif">

    <!-- plugin css -->
    <link href="{{ asset('admin/assets/libs/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.css') }}"
        rel="stylesheet" type="text/css" />

    <!-- preloader css -->
    <link rel="stylesheet" href="{{ asset('admin/assets/css/preloader.min.css') }}" type="text/css" />

    <!-- Bootstrap Css -->


        <link href="{{ asset('admin/assets/css/bootstrap.min.css') }}" id="bootstrap-style" rel="stylesheet"
            type="text/css" />
      <!-- Icons Css -->
    <link href="{{ asset('admin/assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="{{ asset('admin/assets/css/jasny-bootstrap.min.css') }}" rel="stylesheet" type="text/css">


        <link href="{{ asset('admin/assets/css/app.min.css') }}" id="app-style'" rel="stylesheet" type="text/css" />


</head>

<body data-sidebar="dark" data-sidebar-size="lg">

    <!-- <body data-layout="horizontal"> -->

    <!-- Begin page -->
    <div id="layout-wrapper">


        <header id="page-topbar">
            <div class="navbar-header">
                <div class="d-flex">


                    <!-- LOGO -->
                    <div class="navbar-brand-box">
                        <a class="logo logo-dark" href="https://www.aryanict.com/" target="__blank">

                            <span class="logo-lg">
                                <img src="{{asset('static/images/logo-png.png')}}" height="24"
                                    alt="ARYAN ICT Solutions">
                            </span>
                        </a>

                        <a class="logo logo-light" href="https://www.aryanict.com/" target="__blank">

                            <span class="logo-lg">
                                <img src="{{asset('static/images/logo-png.png')}}" height="24"
                                    alt="ARYAN ICT Solutions">
                            </span>
                        </a>


                    </div>

                    <button type="button" class="btn btn-sm px-3 font-size-16 header-item" id="vertical-menu-btn">
                        <i class="fa fa-fw fa-bars"></i>
                    </button>
                    <!-- App Search-->

                </div>

                <div class="d-flex">
                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item bg-light-subtle border-start border-end"
                            id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false">

                            <span class="d-none d-xl-inline-block ms-1 fw-medium">{{ Auth::user()->name }}</span>
                            <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                            <!-- item-->
                            <a class="dropdown-item" href="{{ route('users.edit', ['user' => Auth::user()->id]) }}"><i
                                    class="mdi mdi-face-man font-size-16 align-middle me-1"></i>
                                {{ __('dashboard.header.password_change') }}</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item"
                                onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();"
                                href="#"><i class="mdi mdi-logout font-size-16 align-middle me-1"></i>
                                {{ __('dashboard.header.logout') }}</a>
                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </header>

        <!-- ========== Left Sidebar Start ========== -->
        <div class="vertical-menu">

            <div data-simplebar class="h-100">

                <!--- Sidemenu -->
                <div id="sidebar-menu">
                    <!-- Left Menu Start -->
                    <ul class="metismenu list-unstyled" id="side-menu">


                        <li>
                            <a href="{{ route('dashboard.index') }}">
                                <i data-feather="sliders"></i>
                                <span data-key="t-dashboard">{{ __('dashboard.menu.dashboard') }}</span>
                            </a>
                        </li>

                        <li>
                            <a href="{{ route('abouts.index') }}">
                                <i data-feather="info"></i>
                                <span data-key="t-tables"> About</span>
                            </a>
                        </li>

       <li>
                            <a href="javascript: void(0);" class="has-arrow">
                                <i data-feather="cpu"></i>
                                <span data-key="t-icons">Files and Media </span>
                            </a>
                            <ul class="sub-menu" aria-expanded="false">
                                <li><a href="{{ route('imageGallaries.index') }}" data-key="t-boxicons">
                                        Gallery</a></li>

                                    <li><a href="{{ route('banners.index') }}" data-key="t-boxicons">
                                        Banners</a></li>

                                      <li><a href="{{ route('socials.index') }}" data-key="t-boxicons">
                                        Socials and Clients</a></li>

                            </ul>
                        </li>

                          <li>
                            <a href="{{ route('products.index') }}">
                                <i data-feather="briefcase"></i>
                                <span data-key="t-components">Branches</span>
                            </a>

                        </li>

                         <li>
                            <a href="{{ route('posts.index') }}">
                                <i data-feather="briefcase"></i>
                                <span data-key="t-components">posts(client...)</span>
                            </a>

                        </li>




                        <li>
                            <a href="{{ route('slideShows.index') }}">
                                <i data-feather="briefcase"></i>
                                <span data-key="t-components"> Slide Shows</span>
                            </a>

                        </li>

                          <li>
                            <a href="{{ route('events.index') }}">
                                <i data-feather="briefcase"></i>
                                <span data-key="t-components">Events</span>
                            </a>

                        </li>


                         <li>
                            <a href="{{ route('counters.index') }}">
                                <i data-feather="briefcase"></i>
                                <span data-key="t-components">Counters</span>
                            </a>

                        </li>


                          <li>
                            <a href="{{ route('services.index') }}">
                                <i data-feather="briefcase"></i>
                                <span data-key="t-components">Services</span>
                            </a>

                        </li>


                         {{-- <li>
                            <a href="{{ route('donations.index') }}">
                                <i data-feather="box"></i>

                                <span data-key="t-forms">CEO Message</span>
                            </a>
                        </li> --}}

                        <li>
                            <a href="javascript: void(0);" class="has-arrow">
                                <i data-feather="cpu"></i>
                                <span data-key="t-icons"> {{ __('dashboard.menu.setting') }}</span>
                            </a>
                            <ul class="sub-menu" aria-expanded="false">
                                <li><a href="{{ route('companies.index') }}" data-key="t-boxicons">
                                General
                                </a></li>
                                {{-- <li><a href="{{route('pagesimages.index')}}" data-key="t-material-design"> {{__('dashboard.menu.banner')}} </a></li> --}}
                                <li><a href="{{ route('menus.index') }}" data-key="t-dripicons">
                                       Menu </a></li>
                                {{-- <li><a href="{{route('settings.index')}}" data-key="t-font-awesome"> {{__('dashboard.menu.pagination')}} </a></li> --}}
                                <li><a href="{{ route('users.index') }}" data-key="t-knob-charts">
                                        User</a></li>
                            </ul>
                        </li>




                    </ul>

                </div>
                <!-- Sidebar -->
            </div>
        </div>
        <!-- Left Sidebar End -->
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
