@extends('Admin.master_page')

@section('small_title')
Slide Show
@endsection
@section('content')

                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Slide Show</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">  Slide Show </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                                   <!-- end page title -->
                        @if(Session::has('message'))
                        <div class="alert alert-info">{{ Session::get('message') }}</div>

                        @endif
                        </div>



                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">

                                        <a type="button" href="{{route('slideShows.create')}}" class="btn btn-primary ">  Add </a>
                                        </a>


                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">


<div class="table-responsive">

	<table class="table table-striped">
	<tr>
		<th>Title</th>
		<th>English Image</th>
		<th>Dari Image</th>
		<th>Pashto Image</th>
		<th>Action</th>
	</tr>

	@foreach($posts as $item)

	<tr>
		<td>

            <p>
                  {{ $item->title }}
            </p>

             <p>
                  {{ $item->da_title }}
            </p>
              <p>
                  {{ $item->pa_title }}
            </p>

        </td>
		<td>
            <img src="{{render_image_path($item->image)}}" width="150" height="100" title="{{ $item->title}} image">
        </td>

        <td>
            <img src="{{render_image_path($item->da_image)}}" width="150" height="100" title="{{ $item->da_title}} image">
        </td>
         <td>
            <img src="{{render_image_path($item->pa_image)}}" width="150" height="100" title="{{ $item->pa_title}} image">
        </td>



			<td>
                    <form action="{{route('slideShows.destroy' , $item->id)}}" method="post" id="form-{{$item->id}}">
                        {{csrf_field()}}
                        {{method_field("DELETE")}}
                    </form>

                    <a href="{{ route('slideShows.edit' , $item->id) }}" ><i class="fas fa-edit"></i></a>

                    &nbsp;
                                   <a href=""
                       onclick="if(confirm('Are you sure to delete?')) {
                               event.preventDefault();
                               document.getElementById('form-{{$item->id}}').submit();
                               }else{ event.preventDefault(); }"
                       ><i class="fas fa-trash-alt"></i></a>
                </td>


	</tr>

	@endforeach

</table>



<br>

 <div class="container">
                                                            <div class="row justify-content-center">
                                                            {{ $posts->links() }}
                                                        </div>
                                                        </div>
</div>





                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

