@extends('Admin.master_page')
@section('small_title')
{{__("dashboard.menu.user")}}
@endsection
@section('content')



                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18"> {{__("dashboard.menu.user")}}</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active"> {{__("dashboard.menu.user")}}</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                            <div class="alert alert-info">{{ Session::get('message') }}</div>

                            @endif

                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <a type="button" href="{{route('users.create')}}" class="btn btn-primary ">
                                            Add
                                        </a>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">

                                                <div class="table-responsive">

                                                    <table class="table table-striped">
                                                    <tr>
                                                        <th>Title (English)</th>
                                                        <th>Email</th>
                                                        <th>Delete</th>
                                                    </tr>

                                                    @foreach($Users as $Users)

                                                    <tr>
                                                        <td>
                                                            <p>{{ $Users->name }}</p>


                                                        </td>
                                                        <td>
                                                            <p>{{ $Users->email }}</p>


                                                        </td>


                                                            <td>
                                                                    <form action="{{route('users.destroy' , $Users->id)}}" method="post" id="form-{{$Users->id}}">
                                                                        {{csrf_field()}}
                                                                        {{method_field("DELETE")}}
                                                                    </form>

                                                                    &nbsp;
                                                                                   <a href=""
                                                                       onclick="if(confirm('Are you sure to delete?')) {
                                                                               event.preventDefault();
                                                                               document.getElementById('form-{{$Users->id}}').submit();
                                                                               }else{ event.preventDefault(); }"
                                                                       ><i class="fas fa-trash-alt"></i></a>
                                                                </td>


                                                    </tr>

                                                    @endforeach

                                                </table>

                                                <br>
                                                </div>


                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

