@extends('website.layout.main')

@section('meta_title')
   Contact
@endsection
@section('content')

<div class="content-wrapper">

      <section class="contact-us-wrap mt-2 ">
                    <div class="container mt-2 ">
                        <div class="row justify-content-center pt-50">
                            <div class="col-xl-4 col-lg-6 col-md-6 ">
                                <div class="contact-item">
                                    <span class="contact-icon">
                                        <i class="flaticon-map"></i>
                                    </span>
                                    <div class="contact-info">

                                        <p>
                                            {{company()->location1}}
                                        </p>
                                        <p>
                                            {{company()->location2}}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-6 col-md-6">
                                <div class="contact-item">
                                    <span class="contact-icon">
                                        <i class="flaticon-email-2"></i>
                                    </span>
                                    <div class="contact-info">
                                        <a href="mailto::{{company()->email1}}"> {{company()->email1}}</a>
                                        <a href="mailto::{{company()->email2}}"> {{company()->email2}}</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-6 col-md-6">
                                <div class="contact-item">
                                    <span class="contact-icon">
                                        <i class="flaticon-call"></i>
                                    </span>
                                    <div class="contact-info">
                                        <a style="direction: ltr !important" href="tel:{{company()->phone1}}"> {{company()->phone1}}</a>
                                        <a style="direction: ltr !important" href="tel:{{company()->phone2}}"> {{company()->phone2}}</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </section>
    <section class="appointment-wrap style1 bg-athens pt-50" id="orders"  >
                <div class="container">
                    <div class="row gx-5">
                        <div class="col-lg-7 mb-2 mx-auto" data-aos="fade-right" data-aos-duration="1200" data-aos-delay="200">
                            <div class="section-title style1 ">
                                <span>
                                    @lang('front.send_message')
                                </span>
                            </div>
                            <form action="{{render_route('contact.store')}}"  class="appointment-form" method="POST">
                                @csrf
                                  @honeypot


                                    <div class="row">


                                          <div class="col-md-6">
                                               <div class="form-group">
                                        <input type="email" name="email"  id="email"  required placeholder="{{__('front.label.email')}}">
                                         @error('email')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                    </div>

                                        </div>
                                        <div class="col-md-6">
                                               <div class="form-group">
                                        <input type="number" name="phone"  required placeholder="{{__('front.label.phone_number')}}">
                                         @error('phone')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                    </div>
                                        </div>
                                       <div class="col-md-6">
                                         <div class="form-group">
                                          <input type="text" class="form-control"  required name="first_name" placeholder="{{__('front.label.first_name')}}">
                                              @error('first_name')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                        </div>
                                       </div>

                                        <div class="col-md-6">
                                         <div class="form-group">
                                          <input type="text" class="form-control"  required name="last_name" placeholder="{{__('front.label.last_name')}}">
                                            @error('last_name')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                        </div>
                                       </div>



                                         <div class="col-md-12">
                                               <div class="form-group">
                                        <input type="text" name="subject"  required placeholder="{{__('front.subject')}}">
                                         @error('subject')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                    </div>
                                        </div>


                                         <div class="col-md-12">
                                              <div class="form-group v1 has-error has-danger">
                                                    <textarea class="form-control" name="message" id="message" placeholder="@lang('front.message')" cols="30" rows="5" required="" ></textarea>

                                                    @error('message')
                                                       {{$message}}
                                                    @enderror
                                                </div>
                                        </div>



                                        <button class="btn style1">
                                            @lang('front.send')
                                        </button>
                                </form>
                        </div>

                    </div>
                </div>
            </section>


               {{-- Start Clients --}}


               @include('website.partial.__client')
               @include('website.partial.__order')

</div>


@endsection




