<!DOCTYPE html>
<html lang="zxx" lang="{{appLocal()}}" dir="{{get_direction()}}">

<head>
    <!--=== Meta Tags ===-->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    @if (is_rtl())
    <link rel="stylesheet" href="{{asset('rtl/assets/css/meanmenu.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/boxicons.min.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/owl.carousel.min.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/owl.theme.default.min.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/animate.min.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/fonts/flaticon.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/odometer.min.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/nice-select.min.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/magnific-popup.min.css')}}" />

    <link rel="stylesheet" href="{{asset('rtl/assets/css/style.css')}}" />

    <link rel="stylesheet" href="{{asset('rtl/assets/css/responsive.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/bootstrap.rtl.min.css')}}" />
    <link rel="stylesheet" href="{{asset('rtl/assets/css/rtl.css')}}" />
    <style>
        a {
            text-decoration: none !important;
        }
    </style>


    @else
    <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/meanmenu.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/boxicons.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/owl.carousel.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/owl.theme.default.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/animate.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/fonts/flaticon.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/odometer.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/nice-select.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/magnific-popup.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/style.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/responsive.css')}}">

    @endif


    <link
  rel="stylesheet"
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"
  crossorigin="anonymous"
/>

    <!--=== Title & Favicon ===-->

    <title> @yield('meta_title') {{company()?->name}} </title>

    <meta name="description" content="{{company()->description}}">

    <link rel="icon" type="image/png" href="{{render_logo_path(company())}}">


    <style>
      @media (min-width: 768px) {
  .banner-content {
    padding: 0 30px !important;
  }
      }

      .footer-logo ul li a i,.footer-logo ul li i {
        color: #f5f1e6 !important;
      }


       .footer-logo ul li a:hover, .footer-links ul li a:hover {
         color: #006B3C !important
       }

       /* .rules-area .container .rules-item ul li {
        list-style-type: none;
    display: block;
    padding-left: 20px;
    font-weight: 600;
    position: relative;
    margin-bottom: 12px;
       } */

       /* .rules-area .container .rules-item ul li:before{
           position: absolute !important;
    content: "" !important;
    width: 10px !important;
    height: 10px !important;
    top: 7px !important;

    left: 0 !important;
    background-color: #003366 !important;
       } */

    </style>



</head>

<body>
    <!-- Preloader -->
    {{-- <div class="loader">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="spinner">
                    <div class="double-bounce1"></div>
                    <div class="double-bounce2"></div>
                </div>
            </div>
        </div>
    </div> --}}
    <!-- End Preloader -->

    <!-- Header -->
    <div class="header-area two">
        <div class="container">
            <div class="row align-items-center">

                <div class="col-lg-6">
                    <div class="left">
                        <ul>
                            <li>
                                <i class="bx bx-location-plus"></i>
                                <a href="#">
                                    {{company()->location1}}
                                </a>
                            </li>
                            <li>
                                <i class="bx bx-mail-send"></i>
                                <a href="mailto:{{company()->email1}}">
                                    {{company()->email1}}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="right">
                        <ul>
                            <li>
                                <a href="{{company()->facebook}}" target="_blank">
                                       <i class="fa-brands fa-facebook-f" aria-hidden="true"></i>
                                </a>
                            </li>
                            <li>
                                <a href="{{company()->twitter}}" target="_blank">
                                                             <i class="fa-brands fa-x-twitter" aria-hidden="true"></i>

                                </a>
                            </li>

                            <li>
                                <a href="{{company()->linkedin}}" target="_blank">
                                     <i class="fa-brands fa-linkedin-in" aria-hidden="true"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Header -->

    <!-- Navbar -->
    <div class="navbar-area sticky-top">
        <!-- Menu For Mobile Device -->
        <div class="mobile-nav">
            <a href="{{url('/')}}" class="logo">
                <img src="{{render_logo_path(company())}}" alt="Logo">
            </a>
        </div>

        <!-- Menu For Desktop Device -->
        <div class="main-nav two">
            <div class="container">
                <nav class="navbar navbar-expand-md navbar-light">
                    <a class="navbar-brand" href="/">
                        <img src="{{render_logo_path(company())}}" alt="Logo">
                    </a>
                    <div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent" style="display: block;">


                            <ul class="navbar-nav">

                                    @foreach (get_menus() as $item)
                                     <li class="nav-item" >
                                         <a href="{{render_menu_url($item)}}" class="nav-link {{$item->sub_menus? 'dropdown-toggle':''}}">{{render_menu_name($item)}}
                                            @if (count($item->sub_menus)>0)

                                             <i class="bx bx-chevron-down"></i>
                                            @endif
                                         </a>
                                         @if (count($item->sub_menus)>0)
                                         <ul class="dropdown-menu">
                                              @foreach ($item->sub_menus as $sub_item)
                                             <li class="nav-item">

                                                <a href="{{render_sub_menu_url($sub_item)}}" class="nav-link">

                                                      @if ($sub_item->sub_menu_icon)
                                                         {!!$sub_item->sub_menu_icon !!}
                                                     @endif

                                                     {{render_sub_menu_name($sub_item)}}



                                                </a>
                                            </li>
                                         @endforeach
                                        </ul>
                                         @endif
                                    </li>
                                    @endforeach

                                </ul>

                        <div class="side-nav">
                            <div class="language">
                                {{-- <select style="display: none;">


                                    <option>English</option>
                                    <option>العربيّة</option>
                                    <option>Deutsch</option>
                                    <option>Português</option>
                                </select> --}}
                                <div class="nice-select" tabindex="0"><span class="current">
                                     {{get_available_langs()[appLocal()]}}
                                </span>
                                    <ul class="list">
                                        @foreach (get_available_langs() as $key=>$item)
                                        <li data-value="English" class="option selected">
                                             <a  href="{{render_route('local.change',$key)}}">
                                                     {{$item}}
                                                </a>

                                        </li>



                                                @endforeach


                                    </ul>
                                </div>
                            </div>
                            <a class="consultant-btn" href="{{render_route('contact.index')}}">
                                @lang('front.contact')
                            </a>
                        </div>


                        {{-- <ul class="navbar-nav">
                            <li class="nav-item">
                                <a href="#" class="nav-link dropdown-toggle active">Home
                                    <i class="bx bx-chevron-down"></i>
                                    </a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item">
                                        <a href="index.html" class="nav-link">Home Demo One</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="index-2.html" class="nav-link active">Home Demo Two</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="index-3.html" class="nav-link">Home Demo Three</a>
                                    </li>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link dropdown-toggle">Pages <i
                                        class="bx bx-chevron-down"></i></a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item">
                                        <a href="#" class="nav-link dropdown-toggle">Users <i
                                                class="bx bx-chevron-down"></i></a>
                                        <ul class="dropdown-menu">
                                            <li class="nav-item">
                                                <a href="sign-in.html" class="nav-link">Sign In</a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="sign-up.html" class="nav-link">Sign Up</a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class="nav-item">
                                        <a href="loan.html" class="nav-link">Loan</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="apply.html" class="nav-link">Apply Now</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="testimonials.html" class="nav-link">Testimonials</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="team.html" class="nav-link">Team</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="faq.html" class="nav-link">FAQ</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="404.html" class="nav-link">404 Error Page</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="coming-soon.html" class="nav-link">Coming Soon</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="privacy-policy.html" class="nav-link">Privacy Policy</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="terms-conditions.html" class="nav-link">Terms &amp; Conditions</a>
                                    </li>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a href="about.html" class="nav-link">About</a>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link dropdown-toggle">Services <i
                                        class="bx bx-chevron-down"></i></a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item">
                                        <a href="services.html" class="nav-link">Services Style One</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="services-2.html" class="nav-link">Services Style Two</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="service-details.html" class="nav-link">Service Details</a>
                                    </li>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link dropdown-toggle">Projects <i
                                        class="bx bx-chevron-down"></i></a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item">
                                        <a href="projects.html" class="nav-link">Projects Style One</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="projects-2.html" class="nav-link">Projects Style Two</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="project-details.html" class="nav-link">Project Details</a>
                                    </li>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link dropdown-toggle">Blog <i class="bx bx-chevron-down"></i></a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item">
                                        <a href="blog.html" class="nav-link">Blog</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="blog-details.html" class="nav-link">Blog Details</a>
                                    </li>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a href="contact.html" class="nav-link">Contact</a>
                            </li>
                        </ul> --}}

                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Navbar -->
