
<!DOCTYPE html>
<html lang="{{appLocal()}}" dir="{{get_direction()}}">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="{{company()->description}}">
    <link rel="icon" type="image/png" href="{{render_logo_path(company())}}">
    <title> @yield('meta_title')- {{company()->name}} </title>
        <!-- Link of CSS files -->
        @if (is_rtl())
        <link rel="stylesheet" href="{{asset('assets/css_rtl/bootstrap-rtl.min.css')}}">
         <link rel="stylesheet" href="{{asset('assets/css_rtl/flaticon.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css_rtl/remixicon.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css/owl.carousel.min.css')}}">


        <link rel="stylesheet" href="{{asset('assets/css_rtl/odometer.min.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css_rtl/aos.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css_rtl/style.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css_rtl/responsive.css')}}">

        @else
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">
         <link rel="stylesheet" href="{{asset('assets/css/flaticon.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css/remixicon.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css/owl.carousel.min.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css/odometer.min.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css/aos.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css/style.css')}}">
        <link rel="stylesheet" href="{{asset('assets/css/responsive.css')}}">
        @endif



        <link rel="stylesheet" href="{{asset('assets/cutome/style.css')}}">
        <link rel="stylesheet" href="{{asset('assets/cutome/product.css')}}">

        @yield('style')

        <style>
            .header-wrap .navbar .navbar-nav .nav-item a {
                font-weight: bold;
                color: #044f9f;

            }

          h2, h2.main-color, h3 a, .link.style1, h1, h4{
                color: #044f9f !important;
            }

            h3 a:hover {
                color: #0090be !important;
            }

            .company-background {
                background-color: #044f9f;
            }

            .company-background h2 {
                color: white !important;
            }
            .product-home {
                height: 800px;
                background-position: center;
                background-repeat: no-repeat;
                background-size: cover;
                width: 100%;
                margin: -5px 0;

            }

            .hero-slider-product .owl-nav {
                display: none !important;
            }
            @media (max-width:768px){

             .hero-slider-product .owl-nav {
        display: flex !important;
        justify-content: space-between;
        position: absolute;
        top: 50%;
        width: 100%;
        transform: translateY(-50%);
        pointer-events: none;
    }

   .hero-slider-product .owl-nav i {
        font-size: 24px;
        pointer-events: auto; /* Make sure icons are clickable */
    }

                .hero-wrap{
                    margin-top: 20px !important;
                }
            }
        </style>

    </head>
    <body>



        <!-- Page Wrapper End -->
        <div class="page-wrapper">

            <!-- Header Section Start -->
            <header class="header-wrap style1">
                <div class="header-top">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <div class="header-top-left">
                                    <ul class="contact-info list-style">
                                        <li>
                                            <span>
                                                <i class="flaticon-email-1"></i></span>
                                            <a href="mailto:{{company()->email1}}">{{company()->email1}}</a>
                                        </li>
                                        <li>
                                            <span><i class="ri-phone-fill"></i></span>
                                            <a href="tel:{{company()->phone1}}" style="direction: ltr !important">{{company()->phone1}}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="header-top-right">
                                    <div class="select-lang">
                                        <i class="ri-earth-fill"></i>
                                        <div class="navbar-option-item navbar-language dropdown language-option">
                                            <button class="dropdown-toggle" type="button" data-bs-toggle="dropdown"
                                                aria-haspopup="true" aria-expanded="false">
                                                <span >
                                                   {{get_available_langs()[appLocal()]}}
                                                </span>
                                            </button>
                                            <div class="dropdown-menu language-dropdown-menu">
                                                @foreach (get_available_langs() as $key=>$item)
                                                     <a class="dropdown-item" href="{{render_route('local.change',$key)}}">
                                                     {{$item}}
                                                </a>
                                                @endforeach

                                            </div>
                                        </div>
                                    </div>
                                    <ul class="social-profile list-style style1">
                                        <li>
                                            <a href="{{company()->facebook}}" target="__blank">
                                                <i class="ri-facebook-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{company()->twitter}}" target="__blank">
                                                <i class="ri-twitter-fill"></i>
                                            </a>
                                        </li>
                                          <li>
                                            <a  href="{{company()->instagram}}" target="__blank">
                                                <i class="ri-instagram-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{company()->linkedin}}" target="__blank">
                                                <i class="ri-linkedin-fill"></i>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="header-bottom">
                    <div class="container">
                        <nav class="navbar navbar-expand-md navbar-light">
                           <a class="navbar-brand" href="{{url("/".appLocal())}}">
                                <img class="logo-light" style="height: 60px;" src="{{render_logo_path(company())}}" alt="logo">
                            </a>
                            <div class="collapse navbar-collapse main-menu-wrap" id="navbarSupportedContent">
                                <div class="menu-close d-lg-none">
                                    <a href="javascript:void(0)"> <i class="ri-close-line"></i></a>
                                </div>
                                <ul class="navbar-nav ms-auto">

                                    @foreach (get_menus() as $item)
                                     <li class="nav-item" >
                                         <a href="{{render_menu_url($item)}}" class="nav-link">{{render_menu_name($item)}}
                                            @if (count($item->sub_menus)>0)
                                            <i class="ri-arrow-down-s-line"></i>
                                            @endif
                                         </a>
                                         @if (count($item->sub_menus)>0)
                                         <ul class="dropdown-menu">
                                              @foreach ($item->sub_menus as $sub_item)
                                             <li class="nav-item">

                                                <a href="{{render_sub_menu_url($sub_item)}}" class="nav-link">

                                                      @if ($sub_item->sub_menu_icon)
                                                         {!!$sub_item->sub_menu_icon !!}
                                                     @endif

                                                     {{render_sub_menu_name($sub_item)}}



                                                </a>
                                            </li>
                                         @endforeach
                                        </ul>
                                         @endif
                                    </li>
                                    @endforeach
                                    <li class="nav-item d-lg-none">
                                        <a href="#orders" class="nav-link btn style1">{{__('front.order')}}</a>
                                    </li>
                                </ul>
                                <div class="other-options md-none">
                                    {{-- <div class="option-item">
                                        <button class="searchbtn"><i class="ri-search-line"></i></button>
                                    </div> --}}
                                    <div class="option-item">
                                        <a href="#orders" class="btn style2">{{__('front.order')}}</a>
                                    </div>
                                </div>

                            </div>
                        </nav>
                        {{-- <div class="search-area">
                            <input type="search" placeholder="Search Here..">
                            <button type="submit"><i class="ri-search-line"></i></button>
                        </div> --}}
                        <div class="mobile-bar-wrap">
                            {{-- <button class="searchbtn d-lg-none"><i class="ri-search-line"></i></button> --}}
                            <div class="mobile-menu d-lg-none">
                                <a href="javascript:void(0)"><i class="ri-menu-line"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            <!-- Header Section End -->



