@extends('Admin.master_page')
@section('small_title')
{{__("dashboard.menu.sample_activity")}}
@endsection
@section('content')



                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">{{__('dashboard.menu.sample_activity')}} </h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">{{__('dashboard.menu.dashboard')}}</a></li>
                                            <li class="breadcrumb-item active">  {{__('dashboard.menu.sample_activity')}}</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                                   <!-- end page title -->
                        @if(Session::has('message'))
                        <div class="alert alert-info">{{ Session::get('message') }}</div>

                        @endif
                        </div>



                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <a type="button" href="{{route('activities.create')}}" class="btn btn-primary ">  {{__('lable.add')}} </a>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">

	<table class="table table-striped">
        <tr>
            <th> {{__('lable.video_url')}} </th>
            <th>{{__('lable.image')}}</th>
            <th>{{__('lable.description')}}</th>
            <th>{{__('lable.date')}}</th>
            <th>{{__('lable.hour')}}</th>
            <th>{{__('lable.action')}}</th>
        </tr>
    @foreach ($activities as $activity)
        <tr>
            <td>
                <p>{{ $activity->url }}</p>


            </td>
            <td>
                <img src="{{render_image_path($activity->image)}}" width="150" height="100" title="{{ $activity->title}} image">
            </td>
            <td>
                {!! $activity->description!!}


            </td>
            <th>
                {{  $activity->created_at->format('Y-m-d')}}
            </th>
            <th>
                {{  $activity->created_at->format('H:m: a')}}
            </th>



                <td>
                        <form action="{{route('activities.destroy' , $activity->id)}}" method="post" id="form-{{$activity->id}}">
                            {{csrf_field()}}
                            {{method_field("DELETE")}}
                        </form>

                        <a href="{{ route('activities.edit' , $activity->id) }}" ><i class="fas fa-edit"></i></a>

                        &nbsp;
                                       <a href=""
                           onclick="if(confirm('Are you sure to delete?')) {
                                   event.preventDefault();
                                   document.getElementById('form-{{$activity->id}}').submit();
                                   }else{ event.preventDefault(); }"
                           ><i class="fas fa-trash-alt"></i></a>
                    </td>


        </tr>
    @endforeach()

    </table>
                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

