@extends('Admin.master_page')
@section('small_title')
{{__("lable.applicants")}}
@endsection
@section('content')



                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">  {{__('lable.applicant_for')}}   {{$job->title}}: {{count($job->applicants)}} </h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}"> Dashboard  </a></li>
                                            <li class="breadcrumb-item active">   {{__('lable.applicants')}}  </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                            <div class="alert alert-info">{{ Session::get('message') }}</div>

                            @endif

                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">

                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">

                                                <div class="table-responsive">

                                                    <table class="table table-striped">
                                                    <tr>
                                                        <th> Name  </th>
                                                        <th> {{__('lable.applicant_date')}}</th>
                                                        <th>{{__('lable.email')}} </th>
                                                        <th> {{__('lable.detail')}}  </th>
                                                        <th>{{__('lable.action')}} </th>
                                                    </tr>

                                                    @foreach($job->applicants as $item)

                                                    <tr>
                                                        <td>
                                                            <b>
                                                                <a href="{{ route('applicants.show' , ['job'=>$job->id,'applicant'=>$item->id]) }}" >
                                                                {{ $item->first_name }} {{ $item->last_name }}
                                                                </a>

                                                            </b>
                                                        </td>
                                                        <td>
                                                            <p>{{ $item->createdAt1() }}</p>
                                                        </td>

                                                        <td>
                                                            <p>{{ $item->email }}</p>
                                                        </td>


                                                        <td>
                                                            <a href="{{ route('applicants.show' , ['job'=>$job->id,'applicant'=>$item->id]) }}" >
                                                               <i class="fa fa-info" style="font-size: 28"> </i>
                                                            </a>

                                                        </td>
                                                            <td>
                                                                    <form action="{{route('applicants.destroy' , $item->id)}}" method="post" id="form-{{$item->id}}">
                                                                        {{csrf_field()}}
                                                                        {{method_field("DELETE")}}
                                                                    </form>

                                                                    &nbsp;
                                                                                   <a href=""
                                                                       onclick="if(confirm('Are you sure to delete?')) {
                                                                               event.preventDefault();
                                                                               document.getElementById('form-{{$item->id}}').submit();
                                                                               }else{ event.preventDefault(); }"
                                                                       ><i class="fas fa-trash-alt"></i></a>
                                                                </td>


                                                    </tr>

                                                    @endforeach

                                                </table>

                                                <br>
                                                        <br>
                                                        <div class="container">
                                                            <div class="row justify-content-center">

                                                        </div>
                                                        </div>

                                                        <br>
                                                        <br>
                                                        <br>

                                                </div>

                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

