@extends('Admin.master_page')
@section('small_title')
{{__("dashboard.menu.donation")}}
@endsection

@section('content')



                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18"> Edit</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">  Donate  </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                      <div class="alert alert-info">{{ Session::get('message') }}</div>

@endif

                        </div>
                        <!-- end page title -->
                        <div>

                            <form method="post" action="{{ route('donations.update',['donation'=>$donation->id]) }}" enctype="multipart/form-data">
                                @csrf
                                @method('put')

                                <div class="col-lg-12">
                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Info</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{$donation->info}}" name="info" class="form-control" placeholder="">
                                    @error('title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>


                                <h6 class="m-0 font-weight-bold text-primary pull-left" >{{__("lable.status")}} </h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <select class="form-control" name="status">

                                        <option {{$donation->status==1?'selected':''}} value="1" >Active</option>
                                        <option {{$donation->status==0?'selected':''}} value="o">Non Active</option>
                                    </select>
                                    @error('status')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                            </div>

                                <input type="submit" value="Save Changes" class="btn btn-secondary">


                            </form>
                        </div>





</div>
<!-- container-fluid -->
</div>
<!-- End Page-content -->



@endsection




@section('script')
<script>
    CKEDITOR.replace( 'summary-ckeditor1' );

</script>


@endsection
