@extends('Admin.master_page')
@section('small_title')
Gallery
@endsection

@section('content')



                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Edit</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">  Gallery</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                      <div class="alert alert-info">{{ Session::get('message') }}</div>

@endif

                        </div>
                        <!-- end page title -->

<div>

	<form method="post" action="{{ route('imageGallaries.update',['imageGallary'=>$imageGallary->id]) }}" enctype="multipart/form-data">
		@csrf
        @method('put')

		<div class="col-lg-12">
		<h6 class="m-0 font-weight-bold text-primary pull-left" >Type</h6>
		<hr>

		<div class="input-group" style="margin-top: 15px;">
			  <select name="type" class="form-control">
                                          @foreach (gallery_types() as $item)
                                          <option {{$imageGallary->type==$item?'selected':''}} >{{$item}}</option>
                                          @endforeach
                                    </select>
                                    @error('type')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
		</div>
		<br>


            <h6 class="m-0 font-weight-bold text-primary pull-left" >Section</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <select name="section" class="form-control">
                                          @foreach (gallery_sections() as $item)
                                          <option {{$imageGallary->section==$item?'selected':''}}>{{$item}}</option>
                                          @endforeach
                                    </select>
                                    @error('section')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>


                                              <h6 class="m-0 font-weight-bold text-primary pull-left" >Title</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                     <input class="form-control" value="{{$imageGallary->title}}" name="title">
                                    @error('title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
        <h6 class="m-0 font-weight-bold text-primary pull-left" >Image</h6>
		<hr>

		<div class="input-group" style="margin-top: 15px;">
            <div class="fileinput fileinput-new"data-provides="fileinput">
                <div class="fileinput-new img-thumbnail" style="width: 400px; height: 200px;">

                    @if ($imageGallary->type =='Image')
                    <img src="{{ render_image_path($imageGallary->url)}}"   alt="...">
                    @else
                    <video width="100%" height="90%" controls src="{{ render_image_path($imageGallary->url)}}"   alt="..."></video>
                    @endif
                    <input type="hidden" name="old_image" value="{{$imageGallary->url}}">

                </div>
                <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                <div class="mt-2">
                    <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new">   Select Image</span>

                    <span class="fileinput-exists">Edit</span><input type="file"  name="image"></span>
                    <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                </div>
                @error('image')
                <span class="alert-danger">{{ $message }}</span>
                @enderror
            </div>


			@error('image')
			<span class="alert-danger">{{ $message }}</span>
			@enderror
		</div>
		<br>

	</div>

		<input type="submit" value="Save Changes" class=" btn btn-secondary">


	</form>
</div>





</div>
<!-- container-fluid -->
</div>
<!-- End Page-content -->



@endsection




