@extends('Admin.master_page')
@section('small_title')
   Menu
@endsection

@section('content')
    <div class="page-content">
        <div class="container-fluid">

            <!-- start عنوان صحفه -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <div style="margin-right: 50px;display: inline;width: 100px; ">
                            <label>
                                <input type="radio" name="menu" onclick="openNewPage()">
                              New Page
                            </label>
                        </div>

                        <div style="margin-right: 20px;display: inline; width: 100px ">
                            <label>
                                <input type="radio" name="menu" onclick="openCurrentPage()">
                                 Available Pages
                            </label>

                        </div>
                        <div style="margin-right: 20px;display: inline; width: 100px ">
                            <label>
                                <input type="radio" name="menu" onclick="openMenuLabel()">
                               Label For Submenu
                            </label>

                        </div>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">
                                        {{ __('dashboard.menu.dashboard') }}</a></li>
                                <li class="breadcrumb-item active">Menu </li>
                            </ol>
                        </div>

                    </div>
                </div>
                @if (Session::has('message'))
                    <div class="alert alert-info">{{ Session::get('message') }}</div>
                @endif
            </div>
            <!-- end عنوان صحفه -->

            {{-- New Page --}}
            <div id="newPage" style="display:none">
                <hr>

                <form method="post" action="{{ route('menus.store') }}" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" value="page" name="resource_id">
                    <input type="hidden" value="page" name="resource_type">
                    <input type="hidden" value="pages.show" name="route_name">
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (English) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('menu_name') }}" name="menu_name"
                                        class="form-control" placeholder="">
                                    @error('menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                             <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (Dari) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('da_menu_name') }}" name="da_menu_name"
                                        class="form-control" placeholder="">
                                    @error('da_menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                             <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (Pashto) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('pa_menu_name') }}" name="pa_menu_name"
                                        class="form-control" placeholder="">
                                    @error('pa_menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>


                            <input  type="hidden" readonly required min="1" value="{{ $menuOrder }}"
                                        name="menu_order" class="form-control" placeholder="">

                        </div>
                        <br>
                        <br>
                        <br>


                                    <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (English)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{old('title')}}" name="title" class="form-control" placeholder="">
                                    @error('title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                           <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Dari)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{old('da_title')}}" name="da_title" class="form-control" placeholder="">
                                    @error('da_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Pashto)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{old('pa_title')}}" name="pa_title" class="form-control" placeholder="">
                                    @error('pa_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>



                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (English)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="description" id="summary-ckeditor" cols="30" rows="8" class="form-control">
                                          {!!old('description')!!}
                                    </textarea>
                                    @error('description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (Dari)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="da_description" id="summary-ckeditor_da" cols="30" rows="8" class="form-control">
                                          {!!old('da_description')!!}
                                    </textarea>
                                    @error('da_description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (Pashto)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="pa_description" id="summary-ckeditor_pa" cols="30" rows="8" class="form-control">
                                          {!!old('pa_description')!!}
                                    </textarea>
                                    @error('pa_description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Image</h6>
                                <hr>
                                <div class="fileinput fileinput-new"data-provides="fileinput">
                                    <div class="fileinput-new img-thumbnail" style="width: 150px; height: 150px;">
                                        <img src="http://via.placeholder.com/"  alt="...">
                                    </div>
                                    <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                                    <div class="mt-2">
                                        <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new">Select Image </span><span class="fileinput-exists">Edit</span><input type="file" name="image"></span>
                                        <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                                    </div>
                                    @error('image')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>


                    </div>

                    <input type="submit" value="Save" class="btn btn-secondary">

                </form>


            </div>

            {{-- Label For Sub Menus --}}
            <div>
                <div id="subMenuLabel" style="display: none">

                    <hr>
                    <form method="post" action="{{ route('menus.store') }}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" value="menu_label" name="resource_id">
                        <input type="hidden" value="menu label" name="resource_type">
                        <input type="hidden" value="#" name="route_name">
                        <div class="col-lg-12">


                               <div class="row">
                            <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (English) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('menu_name') }}" name="menu_name"
                                        class="form-control" placeholder="">
                                    @error('menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                             <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (Dari) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('da_menu_name') }}" name="da_menu_name"
                                        class="form-control" placeholder="">
                                    @error('da_menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                             <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (Pashto) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('pa_menu_name') }}" name="pa_menu_name"
                                        class="form-control" placeholder="">
                                    @error('pa_menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>


                            <input  type="hidden" readonly required min="1" value="{{ $menuOrder }}"
                                        name="menu_order" class="form-control" placeholder="">

                        </div>

                            <br>
                            <br>
                            <br>
                            <br>
                            <br>




                            <input type="submit" value="ُSave" class=" btn btn-secondary">


                    </form>

                </div>

            </div>

            {{-- Current Page --}}

            <div id="currentPage" style="display: none">
                <hr>
                <form method="post" action="{{ route('menus.store') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="col-lg-12">
                            <div class="row">
                            <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (English) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('menu_name') }}" name="menu_name"
                                        class="form-control" placeholder="">
                                    @error('menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                             <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (Dari) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('da_menu_name') }}" name="da_menu_name"
                                        class="form-control" placeholder="">
                                    @error('da_menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                             <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Name (Pashto) </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{ old('pa_menu_name') }}" name="pa_menu_name"
                                        class="form-control" placeholder="">
                                    @error('pa_menu_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>


                            <input  type="hidden" readonly required min="1" value="{{ $menuOrder }}"
                                        name="menu_order" class="form-control" placeholder="">

                        </div>
                        <br>
                        <br>

                        <div class="row">

                            <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary pull-left">Page </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <select name="route_name" class="form-control">
                                        <option value="">__Select__</option>
                                        @foreach ($pages as $key => $value)
                                            <option @if (old('route_name') === $value) {{ 'selected' }} @endif
                                                value="{{ $value }}">{{ $key }}</option>
                                        @endforeach
                                    </select>

                                    @error('route_name')
                                        <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">

                            </div>

                        </div>
                        <br>
                        <br>
                        <br>




                        <input type="submit" value="Save" class=" btn btn-secondary">


                </form>

            </div>









        </div>







    </div>
    <!-- container-fluid -->
    </div>
    <!-- End Page-content -->
@endsection




@section('script')
<script>
       CKEDITOR.replace( 'summary-ckeditor');
    CKEDITOR.replace( 'summary-ckeditor_da', {
    contentsLangDirection: 'rtl'
} );

   CKEDITOR.replace( 'summary-ckeditor_pa', {
    contentsLangDirection: 'rtl'
} );
</script>

    <script>
        function openCurrentPage() {

            let newPage = document.getElementById("newPage");
            let currentPage = document.getElementById('currentPage');
            let subMenuLabel = document.getElementById("subMenuLabel");
            newPage.style.display = 'none';
            currentPage.style.display = 'block';
            subMenuLabel.style.display = 'none';

        }

        function openNewPage() {
            let newPage = document.getElementById("newPage");
            let currentPage = document.getElementById('currentPage');
            let subMenuLabel = document.getElementById("subMenuLabel");
            newPage.style.display = 'block';
            currentPage.style.display = 'none';
            subMenuLabel.style.display = 'none';

        }

        function openMenuLabel() {

            let newPage = document.getElementById("newPage");
            let currentPage = document.getElementById('currentPage');
            let subMenuLabel = document.getElementById("subMenuLabel");

            newPage.style.display = 'none';

            currentPage.style.display = 'none';
            subMenuLabel.style.display = 'block';


        }
    </script>
@endsection

