@extends('Admin.master_page')
@section('small_title')
product
@endsection
@section('content')
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">  Edit </h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active"> product </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                      <div class="alert alert-info">{{ Session::get('message') }}</div>

@endif

                        </div>
                        <!-- end page title -->

                        <div>
                            <form method="post" action="{{ route('products.update',['product'=>$post->id]) }}" enctype="multipart/form-data">
                                @csrf
                                @method('put')

                                <div class="col-lg-12">
                                          <h6 class="m-0 font-weight-bold text-primary pull-left" >Icon </h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{$post->size}}" name="size" class="form-control" placeholder="">

                                    @error('size')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>



                                    {{-- <h6 class="m-0 font-weight-bold text-primary pull-left" >Real Price </h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="number" required value="{{$post->real_price}}" name="real_price" class="form-control" placeholder="">

                                    @error('real_price')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>

<br/> --}}

                                    {{-- <h6 class="m-0 font-weight-bold text-primary pull-left" >Price </h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="number" required value="{{$post->price}}" name="price" class="form-control" placeholder="">

                                    @error('price')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>

<br/> --}}
                                    {{-- <h6 class="m-0 font-weight-bold text-primary pull-left" >Price Unit </h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <select class="form-control" name="price_unit">
                                    @foreach (price_unit() as $item)
                                         <option {{$item==$post->price_unit?'selected':''}}>{{$item}}</option>
                                    @endforeach
                                    </select>
                                    @error('price_unit')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <br/> --}}
                                {{-- <h6 class="m-0 font-weight-bold text-primary pull-left" >Product Unit</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{$post->product_unit}}" name="product_unit" class="form-control" placeholder="">
                                    @error('product_unit')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br> --}}



                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (English)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{$post->title}}" name="title" class="form-control" placeholder="">
                                    @error('title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                 <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Dari)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{$post->da_title}}" name="da_title" class="form-control" placeholder="">
                                    @error('da_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Title (Pashto)</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" style="direction: rtl"  value="{{$post->pa_title}}" name="pa_title" class="form-control" placeholder="">
                                    @error('pa_title')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                        <h6 class="m-0 font-weight-bold text-primary pull-left" >Location  (Iframe)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="location" cols="30" rows="8" class="form-control">
                                          {!!$post->location!!}

                                    </textarea>
                                    @error('location')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>



                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (English)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="description" id="summary-ckeditor" cols="30" rows="8" class="form-control">
                                          {!!$post->description!!}
                                    </textarea>
                                    @error('description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>

                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (Dari)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="da_description" id="summary-ckeditor_da" cols="30" rows="8" class="form-control">
                                          {!!$post->da_description!!}
                                    </textarea>
                                    @error('da_description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >Description (Pashto)</h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <textarea name="pa_description" id="summary-ckeditor_pa" cols="30" rows="8" class="form-control">
                                          {!!$post->pa_description!!}

                                    </textarea>
                                    @error('pa_description')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>


                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="hidden" name="old_image" value="{{$post->image}}">
                                    <div class="fileinput fileinput-new"data-provides="fileinput">
                                        <div class="fileinput-new img-thumbnail" style="width: 150px; height: 150px;">

                                            <img src="{{ render_image_path($post->image)}}"   alt="...">
                                        </div>
                                        <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                                        <div class="mt-2">
                                            <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new"> English Image </span>

                                            <span class="fileinput-exists">Edit</span><input type="file"  name="image"></span>
                                            <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                                        </div>
                                        @error('image')
                                        <span class="alert-danger">{{ $message }}</span>
                                        @enderror
                                    </div>



                                    @error('image')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror

                                    {{-- <input type="hidden" name="old_caption_image" value="{{$post->caption_image}}">
                                    <div class="fileinput fileinput-new"data-provides="fileinput">
                                        <div class="fileinput-new img-thumbnail" style="width: 150px; height: 150px;">


                                            <img src="{{ render_image_path($post->caption_image)}}"   alt="...">
                                        </div>
                                        <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                                        <div class="mt-2">
                                            <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new"> Center Image </span>

                                            <span class="fileinput-exists">Edit</span><input type="file"  name="caption_image"></span>
                                            <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                                        </div>
                                        @error('caption_image')
                                        <span class="alert-danger">{{ $message }}</span>
                                        @enderror
                                    </div> --}}



                                </div>
                                <br>
                                <br>

                            </div>

                                <input type="submit" value="Save Changes" class=" btn btn-secondary">

                            </form>
                        </div>
</div>
<!-- container-fluid -->
</div>
<!-- End Page-content -->



@endsection


@section('script')
<script>
       CKEDITOR.replace( 'summary-ckeditor');
    CKEDITOR.replace( 'summary-ckeditor_da', {
    contentsLangDirection: 'rtl'
} );

   CKEDITOR.replace( 'summary-ckeditor_pa', {
    contentsLangDirection: 'rtl'
} );
</script>

@endsection

