@extends('Admin.master_page')
@section('small_title')
Social and Clients
@endsection
@section('content')
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">  Edit </h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active"> Social and Clients </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                      <div class="alert alert-info">{{ Session::get('message') }}</div>

@endif

                        </div>
                        <!-- end page title -->

                        <div>
                            <form method="post" action="{{ route('socials.update',['social'=>$post->id]) }}" enctype="multipart/form-data">
                                @csrf
                                @method('put')

                                <div class="col-lg-12">


                                                       <h6 class="m-0 font-weight-bold text-primary pull-left" >Type </h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                     <select name="type" class="form-control">
                                        @foreach (social_types() as $item)
                                          <option {{$post->type==$item?'selected':''}} >{{$item}}</option>
                                        @endforeach
                                     </select>
                                    @error('type')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>


                                  <h6 class="m-0 font-weight-bold text-primary pull-left" >URL</h6>
                                <hr>
                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text"  value="{{$post->url}}" name="url" class="form-control" placeholder="">
                                    @error('url')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>



                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="hidden" name="old_image" value="{{$post->image}}">
                                    <div class="fileinput fileinput-new"data-provides="fileinput">
                                        <div class="fileinput-new img-thumbnail" style="width: 150px; height: 150px;">

                                            <img src="{{ render_image_path($post->image)}}"   alt="...">
                                        </div>
                                        <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                                        <div class="mt-2">
                                            <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new"> English Image </span>

                                            <span class="fileinput-exists">Edit</span><input type="file"  name="image"></span>
                                            <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                                        </div>
                                        @error('image')
                                        <span class="alert-danger">{{ $message }}</span>
                                        @enderror
                                    </div>



                                    @error('image')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror

                                    <input type="hidden" name="old_da_image" value="{{$post->da_image}}">
                                    <div class="fileinput fileinput-new"data-provides="fileinput">
                                        <div class="fileinput-new img-thumbnail" style="width: 150px; height: 150px;">


                                            <img src="{{ render_image_path($post->da_image)}}"   alt="...">
                                        </div>
                                        <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                                        <div class="mt-2">
                                            <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new"> Dari Image </span>

                                            <span class="fileinput-exists">Edit</span><input type="file"  name="da_image"></span>
                                            <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                                        </div>
                                        @error('da_image')
                                        <span class="alert-danger">{{ $message }}</span>
                                        @enderror
                                    </div>



                                    @error('da_image')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror

                                <input type="hidden" name="old_pa_image" value="{{$post->da_image}}">

                                    <div class="fileinput fileinput-new"data-provides="fileinput">
                                        <div class="fileinput-new img-thumbnail" style="width: 150px; height: 150px;">


                                            <img src="{{ render_image_path($post->pa_image)}}"   alt="...">
                                        </div>
                                        <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: 150px; max-height: 150px;"></div>
                                        <div class="mt-2">
                                            <span class="btn btn-outline-secondary btn-file"><span class="fileinput-new"> Pashto Image </span>

                                            <span class="fileinput-exists">Edit</span><input type="file"  name="pa_image"></span>
                                            <a href="#" class="btn btn-outline-secondary fileinput-exists"  data-dismiss="fileinput">Delete</a>
                                        </div>
                                        @error('pa_image')
                                        <span class="alert-danger">{{ $message }}</span>
                                        @enderror
                                    </div>



                                    @error('pa_image')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                <br>

                            </div>

                                <input type="submit" value="Save Changes" class=" btn btn-secondary">

                            </form>
                        </div>
</div>
<!-- container-fluid -->
</div>
<!-- End Page-content -->



@endsection



