@extends('Admin.master_page')
@section('small_title')
{{__("dashboard.menu.user")}}
@endsection

@section('content')

                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18"> Add </h4>
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active"> {{__("dashboard.menu.user")}} </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
<div class="alert alert-info">{{ Session::get('message') }}</div>

@endif
                        </div>
                        <!-- end page title -->

                        <div>
                            <form method="post" action="{{ route('users.store') }}" enctype="multipart/form-data">
                                @csrf

                                <div class="col-lg-12">



                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Name   </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="text" required value="{{old("name")}}"  name="name" class="form-control" placeholder="">
                                    @error('name')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                <h6 class="m-0 font-weight-bold text-primary pull-left" >Email </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="email" required value="{{old("email")}}"  name="email" class="form-control" placeholder="">
                                    @error('email')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                <h6 class="m-0 font-weight-bold text-primary pull-left" >{{__("lable.password")}}  </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="password" required value="{{old("password")}}"  name="password" id="password" class="form-control" placeholder="">
                                    @error('password')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                <h6 class="m-0 font-weight-bold text-primary pull-left" >
                                    {{__("lable.password_confirmation")}}
                                </h6>
                                <hr>

                                <div class="input-group" style="margin-top: 15px;">
                                    <input type="password" id="password_confirmation" value="{{old("password_confirmation")}}"  required name="password_confirmation" class="form-control" placeholder="">
                                    @error('password_confirmation')
                                    <span class="alert-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <br>
                                <p>
                                    <input type="checkbox" onclick="showPassword()" >
                                    {{__('lable.view_password')}}
                                </p>




                            </div>

                                <input type="submit" value=" Save" class=" btn btn-secondary">


                            </form>
                        </div>







</div>
<!-- container-fluid -->
</div>
<!-- End Page-content -->



@endsection




@section('script')
<script>
  function showPassword(){

     let password = document.getElementById('password');

     let password_confirmation = document.getElementById('password_confirmation');
    if(password.type==='password'){
        password.type = 'text';
        password_confirmation.type = 'text';
    }else{
        password.type = 'password';
        password_confirmation.type = 'password';

    }
  }

</script>

@endsection
