@extends('website.layout.main')
@section('small_title','services')
@section('content')

    <!-- Page Banner Section -->
    <section class="page-banner">
        @foreach ($banners as $banner)


    <div class="image-layer lazy-image" data-bg="url('{{asset($banner->image)}}')"></div>
    @endforeach
        <div class="bottom-rotten-curve"></div>

        <div class="auto-container">
            <h1>Our Services</h1>
            <ul class="bread-crumb clearfix">
                <li><a href="{{route('website.home')}}">Home</a></li>
                <li class="active">Our Services</li>
            </ul>
        </div>

    </section>
    <!--End Banner Section -->

    <!--What We Do Section-->
    <section class="what-we-do">
        <div class="auto-container">

            <div class="row clearfix">
               @foreach ($services as $service)
                <!--Service Block-->
                <div class="service-block col-xl-3 col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-box">
                        <div class="icon-box"> <img src="{{render_image_path($service->image)}}" style="height: 150px;" alt=""> </div>
                        <h3>{{$service->title}}</h3>
                        <div class="text">
                            {!! str()->words($service->description,20) !!}
                            <br>
                            <br>
                            <div class="link-box clearfix"><a href="{{route('sservices.show',['sservice'=>$service->id])}}" class="theme-btn btn-style-one"><span class="btn-title">Read More</span></a></div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>


        </div>
    </section>




@endsection
