    <section class="appointment-wrap style1 bg-athens pt-50" id="orders" style="min-height: 620px" >
                <div class="container">
                    <div class="row gx-5">
                        <div class="col-lg-12" data-aos="fade-right" id="OrderFirstForm" data-aos-duration="1200" data-aos-delay="200">
                            <div class="section-title style1 ">
                                <h4>
                                    @lang('front.order_product')
                                </h4>
                            </div>


                            <form action="{{render_route('product.order')}}"  id="productOrderForm" class="appointment-form" method="POST">
                                @csrf
                                  @honeypot


                                    <div class="row">
                                        <div class="col-md-6">
                                               <div class="form-group">
                                        <input id="phone1" type="number" name="phone"  required placeholder="{{__('front.label.phone_number')}}">
                                         @error('phone')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                    </div>
                                        </div>
                                       <div class="col-md-3">
                                         <div class="form-group">
                                          <input id="first_name1" type="text" class="form-control"  required name="first_name" placeholder="{{__('front.label.first_name')}}">
                                              @error('first_name')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                        </div>
                                       </div>
                                        <div class="col-md-3">
                                         <div class="form-group">
                                          <input id="last_name1" type="text" class="form-control"  required name="last_name" placeholder="{{__('front.label.last_name')}}">
                                            @error('last_name')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                        </div>
                                       </div>

                                         <div class="col-md-6">
                                               <div class="form-group">
                                        <input id="email1" type="email" name="email"    required placeholder="{{__('front.label.email')}}">
                                         @error('email')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                    </div>

                                        </div>


                                         <div class="col-md-6">
                                         <div class="form-group">
                                          <input type="text" id="city1" class="form-control"  required name="city" placeholder="{{__('front.label.city')}}">
                                              @error('city')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                        </div>
                                       </div>
                                        <div class="col-md-6">
                                             <div class="form-group">
                                        <select name="province"  required id="province1">
                                            <option value="{{null}}" data-display="Select Province">
                                                {{__('front.label.select_province')}}
                                            </option>
                                           @foreach (provinces() as $item)
                                           <option >{{$item}}</option>
                                           @endforeach
                                        </select>
                                           @error('province')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                    </div>
                                       </div>




                                        <div class="form-group col-6">
                                        <input type="text" name="address"  required  id="address1" placeholder="{{__('front.label.address')}}">
                                         @error('address')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                    </div>
  </div>

                                     <div class="content-title style1">
                                    <h4>
                                        @lang('front.product_selection')
                                    </h4>
                                </div>

                                <div class="row">

                                <div class="form-group col-6">
                                        <select  id="select_product1" required>
                                            {{-- <option value="0" data-display="Select Product">
                                                {{__('front.label.select_product')}}
                                            </option> --}}
                                           @foreach (get_product_for_order() as $item)
                                           <option value="{{$item}}" >
                                              {{render_post_title($item)}}
                                           </option>
                                           @endforeach
                                        </select>
                                        @error('product_id')
                                         <div class="text-danger">
                                            {{$message}}
                                         </div>
                                        @enderror
                                    </div>
                                       <div class="form-group col-6">
                                          <input type="number" min="1" id="quantity1"   required class="form-control"  name="quantity" placeholder="{{__('front.label.quantity')}}">
                                              @error('quantity')
                                            <div class="text-danger">
                                               {{$message}}
                                            </div>
                                         @enderror
                                        </div>



                            <div class="col-md-2 mb-1  offset-md-7 ">
                                         <button type="reset" class="btn style1" id="formResetBtn">
                                @lang('front.cancel')
                            </button>
                                    </div>
                                      <div class="col-md-3 mb-1">

                            <button type="submit" class="btn style2"  id="formSubmitBtn">
                                @lang('front.continue_shopping')
                            </button>

                                    </div>
                                    </div>
                                </form>
                        </div>



                        <div class="col-lg-12 aos-init aos-animate" id="complete_order" style="display: none"  data-aos="fade-right" data-aos-duration="1200" data-aos-delay="200">

                            <form action="{{render_route('product.order')}}" class="appointment-form" id="secondOrderForm" method="post">

                                  @csrf
                                  @honeypot

                                    <input type="hidden" name="email"  id="email">
                                    <input type="hidden" name="first_name"  id="first_name">
                                    <input type="hidden" name="last_name"  id="last_name">
                                    <input type="hidden" name="address"  id="address">
                                    <input type="hidden" name="phone"  id="phone">
                                    <input type="hidden" name="city"  id="city">
                                    <input type="hidden" name="province"  id="province">
                                    <input type="hidden" name="product_id"  id="productId">
                                    <input type="hidden" name="quantity"  id="productQuantity">


                            <div class="appointment-content">
                                <div>
                                     <div class="content-title style1 mb-0">
                                    <h4>
                                        @lang('front.shopping_summary')
                                    </h4>
                                </div>
                                <ul class="content-feature-list list-style mb-2">
                                    <li><i class="ri-checkbox-circle-line"></i>
                                        <strong>@lang('front.product'):</strong>
                                        <span id="summaryProduct"></span>
                                    </li>
                                    <li><i class="ri-checkbox-circle-line"></i>
                                     <strong>
                                        @lang('front.label.price'):
                                     </strong>
                                     <div style="direction: ltr !important;display: inline-block">


                                     {{-- <span style="text-decoration: line-through">
                                       <span id="summaryRealPrice" ></span>
                                       <span id="summaryUnit1" ></span>
                                     </span> --}}

                                     &nbsp;
                                     <span>
                                         <span id="summaryPrice"></span>
                                         <span id="summaryUnit"></span>
                                     </span>

                                    </div>

                                </li>

                                    <li><i class="ri-checkbox-circle-line"></i>
                                         <strong>
                                            @lang('front.label.payment'):
                                         </strong>
                                         <span>
                                            @lang('front.label.cod')
                                         </span>
                                    </li>

                                        <li><i class="ri-checkbox-circle-line"></i>
                                      <strong>
                                          @lang('front.label.address'):
                                      </strong>
                                      <span id="summaryAddress">

                                      </span>
                                    </li>









                                      <li><i class="ri-checkbox-circle-line"></i>
                                        <strong>
                                            @lang('front.label.product_unit'):
                                        </strong>
                                        <span id="summaryProductUnit">

                                        </span>
                                    </li>
<li><i class="ri-checkbox-circle-line"></i>
                                      <strong>
                                        @lang('front.label.total_price'):
                                      </strong>
                                      <div style="display: inline-block; direction: ltr">

                                          <span id="summaryTotalPrice">
                                        </span>
                                        <span id="summaryUnit3">
                                        </span>
                                    </div>
                                    </li>



                                    <li><i class="ri-checkbox-circle-line"></i>
                                        <strong>
                                            @lang('front.label.quantity'):
                                        </strong>
                                        <span id="summaryQuantity">

                                        </span>
                                    </li>
                                      <li><i class="ri-checkbox-circle-line"></i>
                                        <strong>
                                            @lang('front.label.email'):
                                        </strong>
                                        <span id="summaryEmail">

                                        </span>
                                    </li>
                                </ul>
                            </div>



                            <div class="row">
                                 <div class="col-md-2 mb-1  offset-md-8 ">
                                         <button type="reset" id="resetOrderBtn" class="btn style1" >
                                @lang('front.back')
                            </button>
                                    </div>
                                      <div class="col-md-2 mb-1">

                            <button type="submit" class="btn style2">
                                @lang('front.submit')
                            </button>

                                    </div>
                            </div>
                        </div>

                            </form>
                        </div>
                    </div>
                </div>
            </section>



@section('script')



<script>
   $(document).ready(function(){
      $('#productOrderForm').submit(function(event){
                event.preventDefault();

                let email = $('#email1').val();
                let phone = $('#phone1').val();
                let first_name = $('#first_name1').val();
                let last_name = $('#last_name1').val();
                let city = $('#city1').val();
                let address= $('#address1').val();
                let quantity = $('#quantity1').val();
                let province = $('#province1').val();
                let product1 = $('#select_product1').val();
                let product = JSON.parse(product1);
                let price = product.price;


                // show in the form hinnden element
                $('#email').val(email)
                $('#first_name').val(first_name)
                $('#last_name').val(last_name)
                $('#phone').val(phone)
                $('#address').val(address)
                $('#city').val(city)
                $('#province').val(province)
                $('#productId').val(product.id);
                $('#productQuantity').val(quantity);

                if ("{{appLocal()}}" == 'da') {
                $('#summaryProduct').text(product.da_title);
                }else if("{{appLocal()}}" == 'pa'){
                 $('#summaryProduct').text(product.pa_title);
                }
                else {
                 $('#summaryProduct').text(product.title);
                }


                // Show text in the lable
                 $('#summaryEmail').text(email);
                  $('#summaryAddress').text(address);

           $('#summaryPrice').text(product.price);
        //    $('#summaryRealPrice').text(product.real_price);

           $('#summaryUnit').text(product.price_unit);
           $('#summaryUnit1').text(product.price_unit);
           $('#summaryUnit3').text(product.price_unit);

           $('#summaryProductUnit').text(product.product_unit);
           $('#summaryQuantity').text(quantity);
            const totalPrice  = price*quantity;
            $('#summaryTotalPrice').text(`${totalPrice}`);



                 $('#OrderFirstForm').hide();
                $('#complete_order').show();


        return;
    });


    $('#resetOrderBtn').click(function(){

          $('#OrderFirstForm').show();
                $('#complete_order').hide();

    });


    //    $('#select_product').change(function(){
    //     if (this.value==0) {
    //         return
    //     }
    //     const product = JSON.parse(this.value);
    //     if ("{{appLocal()}}" == 'da') {
    //        $('#summaryProduct').text(product.da_title);

    //     }else if("{{appLocal()}}" == 'pa'){
    //        $('#summaryProduct').text(product.pa_title);
    //     }
    //     else {
    //        $('#summaryProduct').text(product.title);
    //     }
    //        $('#summaryPrice').text(product.price);
    //        $('#summaryUnit').text(product.price_unit);

    //        $('#summaryProductUnit').text(product.product_unit);
    //        $('#productId').val(product.id);


    // })



    // $('#quantity').on('change',function(){
    //     const quantity = this.value;
    //     $('#summaryQuantity').text(quantity);


    //     const price =$('#summaryPrice').text();
    //     const priceUnit =$('#summaryUnit').text();

    //     const totalPrice  = price*quantity;
    //     $('#summaryTotalPrice').text(`${totalPrice} ${priceUnit}`);
    //     $('#productQuantity').val(quantity);

    // })


})

</script>

@endsection
