@extends('website.layout.main')

@section('meta_title')
  Daily Water Intake Calculator
@endsection

@section('style')

  <link rel="stylesheet" href="{{asset('assets/cutome/banner.css')}}" type="text/css">
@endsection
@section('content')
<br>
<div class="content-wrapper">



<div class="banner-custome text-center " style="height: 500px !important">
    @if (get_banners('water_calculator_details')->type=='Image')
    <img src="{{render_image_path(get_banners('water_calculator_details')->image)}}"  class="banner-image">
    @else
     <video class="banner-video" autoplay muted loop>
        <source  src="{{render_image_path(get_banners('water_calculator_details')->image)}}"  >
        Your browser does not support the video .
    </video>

    @endif
    <div class="container banner-text">
        <h3>
          {{render_post_title(get_banners('water_calculator_details'))}}
        </h3>

        <div class="col-md-8 mx-auto">
             <p >
          {{strip_tags(str()->words(render_post_description(get_banners('water_calculator_details')),40))}}
        </p>

        <div class="row g-10">
            <div class="col-md-6 mt-2">
                 <div class="form-group">
               <label for="weight">@lang('front.weight')</label>
               <input type="range" class="form-range" id="customRange" min="30" max="200" step="1">
               <div >
                <span class="range-value" id="rangeValue">50</span>
                <strong>
                    @lang('front.kg')
                </strong>
            </div>

        </div>

            </div>

             <div class="col-md-6 mt-2">
                 <div class="form-group">
               <label for="weight">@lang('front.age')</label>
               <input type="range" class="form-range" id="customRange1" min="10" max="70" step="1">
               <div >
                <span class="range-value" id="rangeValue1">15</span>
                <strong>
                    @lang('front.year')
                </strong>
            </div>
        </div>

            </div>
            <div class="col-md-12 mt-2">
                <div id="waterResult" style="display: none;font-size:22px !important;font-weight: 22px !important">
                     @lang('front.water_result')
                      <span id="resultAmount"></span>
                     @lang('front.daily')

                </div>

            </div>

            <div class="col-md-2 mt-10 mx-auto">
                <button class="btn style1 history-btn" id="waterCalculatorBtn" >
                    @lang('front.calculat_now')
                </button>
            </div>

        </div>


        </div>
    </div>
</div>


</div>

    {{-- Start Clients --}}
      @include('website.partial.__client')
    {{-- End Clients --}}


    {{-- Start Order  --}}
     @include('website.partial.__order')

    {{-- End Order  --}}
@endsection

@push('scripts')
  <script>
    const rangeInput = document.getElementById('customRange');
    const rangeValue = document.getElementById('rangeValue');

    rangeInput.addEventListener('input', function() {
      rangeValue.textContent = rangeInput.value;
    });

    // Set initial value
    rangeValue.textContent = rangeInput.value;



       const rangeInput1 = document.getElementById('customRange1');
    const rangeValue1 = document.getElementById('rangeValue1');

    rangeInput1.addEventListener('input', function() {
      rangeValue1.textContent = rangeInput1.value;
    });

    // Set initial value
    rangeValue1.textContent = rangeInput1.value;
  </script>

  <script>


   $(document).ready(function(){


    $('#customRange').change(function(){
         const range = $('#customRange').val();
         let baseIntake = range * 0.033; // Base intake in liters
          const age = $('#customRange1').val();

           if (age >= 51) {
            baseIntake += 1; // Adjust for older age
         }else if (age >= 31) {
          baseIntake += 0.5; // Adjust for middle age
           }
         $('#resultAmount').text(baseIntake.toFixed(2));

    })


      $('#customRange1').change(function(){
         const range = $('#customRange').val();
         let baseIntake = range * 0.03; // Base intake in liters
          const age = $('#customRange1').val();

           if (age >= 51) {
            baseIntake += 1; // Adjust for older age
         }else if (age >= 31) {
          baseIntake += 0.5; // Adjust for middle age
           }
         $('#resultAmount').text(baseIntake.toFixed(2));

    })

       $('#waterCalculatorBtn').click(function(){

          const range = $('#customRange').val();
         let baseIntake = range * 0.033; // Base intake in liters
          const age = $('#customRange1').val();

           if (age >= 51) {
            baseIntake += 1; // Adjust for older age
         }else if (age >= 31) {
          baseIntake += 0.5; // Adjust for middle age
           }
         $('#resultAmount').text(baseIntake.toFixed(2));

        $('#waterResult').css('display','block');

    });


   });



  </script>

@endpush
