@extends('website.layout.main')
@section('small_title', 'Our news')
@section('content')
    <!-- Start Causes Area -->
    <section class="causes-section pt-100 pb-100">
        <div class="container">
            <div class="section-title">
                <h2>Program Areas</h2>
            </div>

            <div class="row">
                @foreach ($news as $item)
                    <div class="col-lg-4 col-md-6">
                        <div class="single-causes">
                            <img src="{{ render_image_path($item->image) }}" alt="image" style="height: 380px">


                            <div class="causes-content">

                                <h3>
                                    {{ $item->title }}
                                </h3>
                                <p>
                                    {{ str()->words(strip_tags($item->description), 15) }}
                                </p>


                                <a href="{{ route('swhatwes.show', $item->id) }}" class="causes-btn-one">
                                    Read more ...
                                    <i class="flaticon-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach









                <div class="col-lg-12 col-md-12">
                    <div class="pagination-area">
                        {{ $news->links() }}
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Causes Area -->

@endsection


<!-- Main Footer -->
