let provincesId = document.getElementById("provincesId");
let provincesCode = provincesId.value.split(",");

let provincesNames = document.getElementById("provinceName");
let linkText = document.getElementById("linkText").value;

provincesNames = provincesNames.value.split(",");

let newProvinces = {};
let provincesLabel = {};
let provincesLocation = {};
provincesCode.forEach((elm) => {
    let officeAddress = document
        .getElementById(elm)
        .getAttribute("description");
    if (officeAddress == null) officeAddress = " ";

    let pUrl = document.getElementById(elm).getAttribute("projectUrl");
    if (!pUrl) projectUrl = " ";
    Object.assign(newProvinces, {
        [elm]: {
            url: pUrl,
            name: document.getElementById(elm).value,
            color: document.getElementById(elm).getAttribute("color").trim(),
            description: officeAddress,
        },
    });
});

provincesCode.forEach((elm) => {
    Object.assign(provincesLabel, {
        [elm]: {
            parent_id: elm,
            // color: "white",
            size: 12,
            name: document.getElementById(elm).value,
        },
    });
});

provincesNames.forEach((elm, index) => {
    let officeAddress = document
        .getElementById(elm)
        .getAttribute("description");
    let locationSize = 16;
    if (officeAddress == null) officeAddress = " ";
    let pUrl = document.getElementById(elm).getAttribute("projectUrl");
    if (!pUrl) {
        projectUrl = " ";
        locationSize = 0;
    }

    Object.assign(provincesLocation, {
        [index]: {
            lat: document.getElementById(elm).value.trim(),
            lng: document.getElementById(elm).getAttribute("lng").trim(),
            name: elm,
            url: pUrl,
            size: locationSize,
            description: officeAddress,
        },
    });
});

var simplemaps_countrymap_mapdata = {
    main_settings: {
        //General settings
        width: "500", //or 'responsive'
        background_color: "#FFFFFF",
        background_transparent: "yes",
        border_color: "#ffffff",
        pop_ups: "detect",

        //State defaults
        // state_description: "Office Address",
        state_color: "#88A4BC",
        state_hover_color: "#337d5b",
        state_url: "http://www.aabrar.org.af/",
        border_size: 1.5,
        all_states_inactive: "no",
        all_states_zoomable: "yes",

        //Location defaults
        location_description: "",
        location_url: "",
        location_color: "red",
        location_opacity: 0.8,
        location_hover_opacity: 1,
        location_size: 16,
        location_type: "diamond",
        // location_image_source: "frog.png",
        location_border_color: "#e3781d",
        location_border: 0,
        location_hover_border: 2.5,
        all_locations_inactive: "no",
        all_locations_hidden: "no",

        //Label defaults
        label_color: "white",
        label_hover_color: "black",
        label_size: 22,
        label_font: "Times new roman",
        hide_labels: "no",
        hide_eastern_labels: "no",

        //Zoom settings
        zoom: "no",
        manual_zoom: "no",
        back_image: "no",
        initial_back: "no",
        initial_zoom: "-1",
        initial_zoom_solo: "no",
        region_opacity: 1,
        region_hover_opacity: 0.6,
        zoom_out_incrementally: "yes",
        zoom_percentage: 0.99,
        zoom_time: 0.5,

        //Popup settings
        popup_color: "white",
        popup_opacity: 0.9,
        popup_shadow: 1,
        popup_corners: 5,
        popup_font: "12px/1.5 Verdana, Arial, Helvetica, sans-serif",
        popup_nocss: "no",

        //Advanced settings
        div: "map",
        auto_load: "yes",
        url_new_tab: "no",
        images_directory: "default",
        fade_time: 0.1,
        link_text: linkText,
    },
    state_specific: newProvinces,
    locations: provincesLocation,
    labels: provincesLabel,
};
